% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{csv_write_options}
\alias{csv_write_options}
\title{CSV Writing Options}
\usage{
csv_write_options(
  include_header = TRUE,
  batch_size = 1024L,
  null_string = "",
  delimiter = ",",
  eol = "\\n",
  quoting_style = c("Needed", "AllValid", "None")
)
}
\arguments{
\item{include_header}{Whether to write an initial header line with column names}

\item{batch_size}{Maximum number of rows processed at a time.}

\item{null_string}{The string to be written for null values. Must not contain quotation marks.}

\item{delimiter}{Field delimiter}

\item{eol}{The end of line character to use for ending rows}

\item{quoting_style}{How to handle quotes. "Needed" (Only enclose values in quotes which need them, because their CSV
rendering can contain quotes itself (e.g. strings or binary values)), "AllValid" (Enclose all valid values in
quotes), or "None" (Do not enclose any values in quotes).}
}
\description{
CSV Writing Options
}
\examples{
tf <- tempfile()
on.exit(unlink(tf))
write_csv_arrow(airquality, tf, write_options = csv_write_options(null_string = "-99"))
}
